<?php
namespace model;

class Score extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'user_id'	=>	'INT UNSIGNED',
				'game_id'	=>	'INT UNSIGNED',
				
				'score'		=>	'INT',
				'type'		=>	'ENUM("number", "time")',
				'order'		=>	'ENUM("asc", "desc")'
			))
		);
	}
	
	// Validation
	public function columns($preset)
	{
		return array
		(
			'user_id'	=>	array('text', array('c_user_exists'=>array($this, 'user_exists'))),
			'game_id'	=>	array('text', array('c_game_exists'=>array($this, 'game_exists'))),
			
			'score'		=>	array('text', array()),
			'type'		=>	array('select', array('number', 'time')),
			'order'		=>	array('select', array('asc', 'desc'))
		);
	}
	
	public function user_exists($id)
	{
		return \model\User::num_rows('WHERE id=?', $id, false);
	}
	
	public function game_exists($id)
	{
		return \model\Game::num_rows('WHERE id=?', $id, false);
	}
}